/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import cpw.mods.fml.client.FMLClientHandler;
import jds.bibliocraft.BiblioRenderHelper;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.models.ModelTable;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemTableRenderer
implements IItemRenderer {
    private ModelTable tableModel = new ModelTable();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int metaTest = item.func_77960_j();
        String textureLoc = "none";
        NBTTagCompound tags = item.func_77978_p();
        if (tags != null && tags.func_74764_b("renderTexture")) {
            textureLoc = tags.func_74779_i("renderTexture");
        }
        boolean isVanilla = item.func_77977_a().toLowerCase().contains("frame");
        switch (type) {
            case ENTITY: {
                this.renderTable(0.0f, -0.52f, 0.0f, metaTest, textureLoc, isVanilla);
                break;
            }
            case EQUIPPED: {
                this.renderTable(0.2f, 0.0f, 0.8f, metaTest, textureLoc, isVanilla);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderTable(0.5f, 0.1f, 0.6f, metaTest, textureLoc, isVanilla);
                break;
            }
            case INVENTORY: {
                this.renderTable(1.0f, 0.3f, 1.0f, metaTest, textureLoc, isVanilla);
                break;
            }
        }
    }

    private void renderTable(float i, float j, float k, int metaData, String texLoc, boolean isVanilla) {
        float scale = 0.0f;
        Tessellator tesselator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        if (texLoc.contentEquals("none")) {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getModelTexture(metaData));
            GL11.glTranslatef((float)i, (float)j, (float)k);
            if (metaData == 6 && isVanilla) {
                this.tableModel.renderLeg(false, false, false, false, true, true);
                this.tableModel.renderTop(true, true, true, true, true);
            } else {
                this.tableModel.renderLeg(false, false, false, false, true, false);
                this.tableModel.renderTop(true, true, true, true, false);
            }
        } else {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(BiblioRenderHelper.getBlockResource(texLoc));
            GL11.glTranslatef((float)i, (float)j, (float)k);
            this.tableModel.renderLeg(false, false, false, false, true, true);
            this.tableModel.renderTop(true, true, true, true, true);
        }
        GL11.glPopMatrix();
    }

    public ResourceLocation getModelTexture(int metadata) {
        switch (metadata) {
            case 0: {
                return CommonProxy.TABLE0;
            }
            case 1: {
                return CommonProxy.TABLE1;
            }
            case 2: {
                return CommonProxy.TABLE2;
            }
            case 3: {
                return CommonProxy.TABLE3;
            }
            case 4: {
                return CommonProxy.TABLE4;
            }
            case 5: {
                return CommonProxy.TABLE5;
            }
            case 6: {
                return CommonProxy.FRAME_BLOCK;
            }
        }
        return CommonProxy.TABLE0;
    }
}

